<?php
require_once __DIR__ . '/includes/initialize.php';
$u = current_user();
$title = $page_title ?? 'Admin';
$content = $content ?? '';
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8"><title><?=htmlspecialchars($title)?> - Pacific Admin</title>
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <style>
    :root{--bg:#0f172a;--panel:#111827;--line:#1f2937;--muted:#9ca3af;--brand:#3b82f6;--danger:#ef4444}
    *{box-sizing:border-box}
    body{margin:0;background:var(--bg);color:#e2e8f0;font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif}
    .app{display:grid;grid-template-columns:260px 1fr;min-height:100vh}
    .side{background:var(--panel);border-right:1px solid var(--line);padding:16px 12px;position:sticky;top:0;height:100vh}
    .brand{display:flex;align-items:center;gap:10px;margin-bottom:14px}
    .brand img{height:32px;width:auto}
    .brand strong{font-size:16px}
    nav a{display:block;padding:10px 12px;border-radius:10px;color:#e2e8f0;text-decoration:none;margin:4px 0}
    nav a:hover{background:#0b1220}
    nav .head{margin-top:14px;color:var(--muted);font-size:12px;padding:6px 12px}
    .main{display:flex;flex-direction:column}
    .top{display:flex;justify-content:space-between;align-items:center;padding:12px 16px;background:var(--panel);border-bottom:1px solid var(--line)}
    .wrap{padding:20px}
    .grid{display:grid;grid-template-columns:repeat(auto-fill,minmax(220px,1fr));gap:16px}
    .card{background:var(--panel);border:1px solid var(--line);border-radius:16px;padding:16px}
    .card h2{margin:0 0 6px;font-size:26px}
    .card span{color:var(--muted);font-size:13px}
    .btn{display:inline-block;padding:8px 12px;background:var(--brand);color:#fff;border-radius:10px;text-decoration:none;font-weight:600}
    .logout{background:var(--danger)}
    @media(max-width:980px){.app{grid-template-columns:1fr}.side{position:relative;height:auto}}
  </style>
</head>
<body>
<div class="app">
  <aside class="side">
    <div class="brand">
      <img src="/adminconsole/uploads/logo.jpeg" alt="logo">
      <strong>Pacific iConnect</strong>
    </div>
    <nav>
      <a href="/adminconsole/index.php">🏠 Dashboard</a>
      <div class="head">MAIN MENUS</div>
      <a href="/adminconsole/masters/index.php">🧩 Masters</a>
      <a href="/adminconsole/operations/index.php">🛠️ Operations</a>
      <a href="/adminconsole/reports/index.php">📊 Reports</a>
      <div class="head">ACCOUNT</div>
      <a href="/adminconsole/logout.php">🚪 Logout</a>
    </nav>
  </aside>

  <main class="main">
    <div class="top">
      <div><strong><?=htmlspecialchars($title)?></strong></div>
      <div>
        <?php if($u): ?>
          <span style="color:#9ca3af;margin-right:10px">Hello, <?=htmlspecialchars($u['name'])?> (<?=htmlspecialchars($u['role'])?>)</span>
        <?php endif; ?>
        
      </div>
    </div>
    <div class="wrap">
      <?= $content ?>
    </div>
  </main>
</div>
</body>
</html>
