<?php
require_once __DIR__ . '/includes/auth.php';
require_login();
$u = current_user();

/* ---------- helpers ---------- */
function table_exists($con,$table){
  $t = mysqli_real_escape_string($con,$table);
  $sql = "SELECT 1 FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name='$t' LIMIT 1";
  $r = mysqli_query($con,$sql); return ($r && mysqli_num_rows($r)===1);
}
function col_exists($con,$table,$col){
  $t = mysqli_real_escape_string($con,$table);
  $c = mysqli_real_escape_string($con,$col);
  $r = mysqli_query($con,"SHOW COLUMNS FROM `$t` LIKE '$c'");
  return ($r && mysqli_num_rows($r)>0);
}
function qcount($con,$sql){
  $r = @mysqli_query($con,$sql);
  if($r && ($row=mysqli_fetch_row($r))) return (int)$row[0];
  return 0;
}

/* ---------- stats ---------- */
$stats = [
  'job_seekers'=>0,'recruiters'=>0,'promoters'=>0,
  'premium_jobs'=>0,'standard_jobs'=>0,
  'applications_today'=>0,'total_applications'=>0,
  'subscriptions'=>0,'revenue'=>0.0
];

/* Users by profile type */
if (table_exists($con,'jos_app_users')) {
  $r = mysqli_query($con,"SELECT profile_type_id, COUNT(*) cnt FROM jos_app_users GROUP BY profile_type_id");
  if($r) while($row=mysqli_fetch_assoc($r)){
    $pt = (int)$row['profile_type_id'];
    if($pt===1) $stats['recruiters']=(int)$row['cnt'];
    if($pt===2) $stats['job_seekers']=(int)$row['cnt'];
    if($pt===3) $stats['promoters']=(int)$row['cnt'];
  }
}

/* Premium jobs (walk-ins) */
if (table_exists($con,'jos_app_walkininterviews')) {
  $stats['premium_jobs'] = qcount($con,"SELECT COUNT(*) FROM jos_app_walkininterviews WHERE COALESCE(job_status_id,0) NOT IN (5,6)");
}

/* Standard jobs (vacancies) — validity + status */
if (table_exists($con,'jos_app_jobvacancies')) {
  $stats['standard_jobs'] = qcount(
    $con,
    "SELECT COUNT(*) FROM jos_app_jobvacancies
     WHERE (COALESCE(validity_apply,0)=0
            OR (COALESCE(validity_apply,0)=1 AND valid_till_date >= CURDATE()))
       AND COALESCE(job_status_id,0) NOT IN (5,6)"
  );
}

/* Applications */
$today = date('Y-m-d');
if (table_exists($con,'jos_app_applications')) {
  $col = col_exists($con,'jos_app_applications','application_date') ? "DATE(application_date)" : "DATE(created_at)";
  $stats['applications_today'] = qcount($con,"SELECT COUNT(*) FROM jos_app_applications WHERE $col = '$today'");
  $stats['total_applications'] = qcount($con,"SELECT COUNT(*) FROM jos_app_applications");
}

/* Subscriptions + revenue (amount_paid, only successful & active) */
if (table_exists($con,'jos_app_usersubscriptionlog')) {
  $where = "end_date >= CURDATE()";
  if (col_exists($con,'jos_app_usersubscriptionlog','payment_status')) {
    $where .= " AND payment_status='success'";
  }
  $r = mysqli_query($con,"SELECT COUNT(*) c, COALESCE(SUM(amount_paid),0) s FROM jos_app_usersubscriptionlog WHERE $where");
  if($r && ($row=mysqli_fetch_assoc($r))){
    $stats['subscriptions'] = (int)$row['c'];
    $stats['revenue'] = (float)$row['s'];
  }
}
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Admin Dashboard</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<link rel="stylesheet" href="/adminconsole/assets/ui.css">
<style>
body{font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;background:#0f172a;color:#e2e8f0;margin:0}
.top{display:flex;justify-content:space-between;align-items:center;padding:14px 18px;background:#111827;border-bottom:1px solid #1f2937}
.wrap{padding:22px;display:grid;grid-template-columns:repeat(auto-fill,minmax(220px,1fr));gap:20px}
.card{background:#111827;padding:18px;border-radius:16px;border:1px solid #1f2937;text-align:center}
.card h2{margin:0;font-size:28px}
.card span{font-size:14px;color:#9ca3af}
.btn{display:inline-block;padding:8px 12px;background:#3b82f6;color:#fff;border-radius:10px;text-decoration:none;font-weight:600}
</style>
</head>
<body>
  <div class="top">
    <div><strong>Pacific Admin</strong></div>
    <div>Hello, <?=htmlspecialchars($u['name'] ?? 'Administrator')?></div>
  </div>

  <div class="wrap">
    <div class="card"><h2><?=$stats['job_seekers']?></h2><span>Job Seekers</span></div>
    <div class="card"><h2><?=$stats['recruiters']?></h2><span>Recruiters</span></div>
    <div class="card"><h2><?=$stats['promoters']?></h2><span>Promoters</span></div>
    <div class="card"><h2><?=$stats['premium_jobs']?></h2><span>Premium Jobs</span></div>
    <div class="card"><h2><?=$stats['standard_jobs']?></h2><span>Standard Jobs</span></div>
    <div class="card"><h2><?=$stats['applications_today']?></h2><span>Applications Today</span></div>
    <div class="card"><h2><?=$stats['total_applications']?></h2><span>Total Applications</span></div>
    <div class="card"><h2><?=$stats['subscriptions']?></h2><span>Active Subscriptions</span></div>
    <div class="card"><h2>₹<?=number_format($stats['revenue'],2)?></h2><span>Revenue (Active Subs)</span></div>
  </div>

  <div style="padding:0 22px 22px">
    <a class="btn" href="/adminconsole/masters/index.php">Open Masters</a>
    <a class="btn" href="/adminconsole/operations/index.php" style="margin-left:8px">Open Operations</a>
    <a class="btn" href="/adminconsole/reports/index.php" style="margin-left:8px">Open Reports</a>
  </div>
</body>
</html>
