<?php
require_once __DIR__ . '/../includes/auth.php';
require_login();

$page_title = 'Subscription Pack Features';
$TABLE = 'jos_app_userfeatures'; // id, profile_type, name, (status), (orderby)

/* ---------- helpers (Languages Master pattern) ---------- */
function keep_params(array $changes = []) {
  $qs = $_GET; foreach ($changes as $k=>$v){ if($v===null) unset($qs[$k]); else $qs[$k]=$v; }
  return '?' . http_build_query($qs);
}
function clean($v){ return trim((string)$v); }
function col_exists($con,$table,$col){
  $r = mysqli_query($con,"SHOW COLUMNS FROM `$table` LIKE '".mysqli_real_escape_string($con,$col)."'");
  return ($r && mysqli_num_rows($r)>0);
}
function ensure_schema($con,$table){
  if(!col_exists($con,$table,'status')){
    mysqli_query($con,"ALTER TABLE `$table` ADD `status` TINYINT(1) NOT NULL DEFAULT 1");
  }
  if(!col_exists($con,$table,'orderby')){
    mysqli_query($con,"ALTER TABLE `$table` ADD `orderby` INT NOT NULL DEFAULT 0");
  }
}
ensure_schema($con,$TABLE);

/* Profile Types (as used in app) */
function profile_types(){
  return [1=>'Job Seeker', 2=>'Recruiter', 3=>'Promoter'];
}

/* ---------- state ---------- */
$err=''; $ok='';
$mode  = $_GET['mode'] ?? 'list';
$view  = $_GET['view'] ?? 'last'; // last | all
$search= clean($_GET['search'] ?? '');
$f_prof= (int)($_GET['profile_type'] ?? 0);
$f_stat= ($_GET['status'] ?? '')!=='' ? (int)$_GET['status'] : '';
$f_order= ($_GET['orderby_eq'] ?? '') !== '' ? (int)$_GET['orderby_eq'] : '';
$sort  = $_GET['sort'] ?? 'order_asc';
if(isset($_GET['ok'])) $ok = clean($_GET['ok']);

$ORDER_MAP = [
  'order_asc'  => 'orderby ASC, id DESC',
  'order_desc' => 'orderby DESC, id DESC',
  'name_asc'   => 'name ASC',
  'name_desc'  => 'name DESC',
  'id_desc'    => 'id DESC',
  'id_asc'     => 'id ASC',
];
$order_by = $ORDER_MAP[$sort] ?? $ORDER_MAP['order_asc'];

/* ---------- POST (save/delete) ---------- */
if($_SERVER['REQUEST_METHOD']==='POST'){
  if(!verify_csrf($_POST['csrf'] ?? null)){
    $err='Invalid request. Please refresh.';
  } else {
    if(isset($_POST['save'])){
      $id=(int)($_POST['id'] ?? 0);
      $name=clean($_POST['name'] ?? '');
      $profile_type=(int)($_POST['profile_type'] ?? 0);
      $status=(int)($_POST['status'] ?? 1);
      $orderby=(int)($_POST['orderby'] ?? 0);

      if($name==='' || $profile_type<=0){
        $err='Name and Profile Type are required.';
      } else {
        // duplicate check (name+profile_type)
        $st=mysqli_prepare($con,"SELECT id FROM `$TABLE` WHERE LOWER(name)=LOWER(?) AND profile_type=? AND id<>? LIMIT 1");
        mysqli_stmt_bind_param($st,'sii',$name,$profile_type,$id);
        mysqli_stmt_execute($st);
        $dup=mysqli_stmt_get_result($st);
        if($dup && mysqli_num_rows($dup)>0){
          $err='Feature already exists for this Profile Type.';
        } else {
          if($id>0){
            $st=mysqli_prepare($con,"UPDATE `$TABLE` SET name=?, profile_type=?, status=?, orderby=? WHERE id=?");
            mysqli_stmt_bind_param($st,'siiii',$name,$profile_type,$status,$orderby,$id);
            mysqli_stmt_execute($st);
            $ok='Updated successfully.';
          } else {
            $st=mysqli_prepare($con,"INSERT INTO `$TABLE` (name, profile_type, status, orderby) VALUES (?,?,?,?)");
            mysqli_stmt_bind_param($st,'siii',$name,$profile_type,$status,$orderby);
            mysqli_stmt_execute($st);
            $ok='Saved successfully.';
          }
          header("Location: ". keep_params(['mode'=>null,'id'=>null,'ok'=>$ok]));
          exit;
        }
      }
    }
    if(isset($_POST['delete'])){
      $id=(int)($_POST['id'] ?? 0);
      if($id>0){
        $st=mysqli_prepare($con,"DELETE FROM `$TABLE` WHERE id=?");
        mysqli_stmt_bind_param($st,'i',$id);
        mysqli_stmt_execute($st);
        $ok='Deleted successfully.';
        header("Location: ". keep_params(['mode'=>null,'id'=>null,'ok'=>$ok]));
        exit;
      } else $err='Invalid record.';
    }
  }
}

/* ---------- render ---------- */
ob_start();
?>
<div class="master-wrap">

  <!-- HEADBAR (title + actions) -->
  <div class="headbar" style="display:flex;align-items:center;justify-content:space-between">
    <div>
      <h2 style="margin:0;"><?=$page_title?></h2>
      <?php
        // count total & showing count
        $whereCount = " WHERE 1=1 ";
        if($search!==''){ $s=mysqli_real_escape_string($con,strtolower($search)); $whereCount.=" AND (LOWER(name) LIKE '%$s%')"; }
        if($f_prof>0){ $whereCount.=" AND profile_type=".intval($f_prof); }
        if($f_stat!==''){ $whereCount.=" AND status=".intval($f_stat); }
        if($f_order!==''){ $whereCount.=" AND orderby=".$f_order; }
        $cntRes = mysqli_query($con,"SELECT COUNT(*) AS cnt FROM `$TABLE` $whereCount");
        $total = 0; if($cntRes){ $rowCnt=mysqli_fetch_assoc($cntRes); $total=(int)$rowCnt['cnt']; }
        $showing = ($view==='all') ? $total : min(50,$total);
        $sort_label_map = [
          'order_asc'=>'Order Level ↑', 'order_desc'=>'Order Level ↓',
          'name_asc'=>'Name A–Z','name_desc'=>'Name Z–A','id_desc'=>'Newest first','id_asc'=>'Oldest first'
        ];
      ?>
      <div style="color:#9aa3b2;font-size:0.95rem;margin-top:6px">
        Showing <?=$showing?> of <?=$total?> (sorted: <?=htmlspecialchars($sort_label_map[$sort] ?? $sort)?>)
      </div>
    </div>

    <div style="display:flex;gap:8px;align-items:center">
      <a class="btn success" href="<?=keep_params(['mode'=>'form','id'=>null])?>" style="padding:10px 14px">Add New</a>
      <a class="btn secondary" href="<?=keep_params(['view'=>$view==='all'?'last':'all'])?>" style="padding:10px 14px"><?=$view==='all'?'Show Last 50':'View All'?></a>
    </div>
  </div>

  <?php if($err): ?><div class="alert error"><?=htmlspecialchars($err)?></div><?php endif; ?>
  <?php if($ok):  ?><div class="alert success"><?=htmlspecialchars($ok)?></div><?php endif; ?>

<?php if($mode==='form'):
  $id=(int)($_GET['id'] ?? 0);
  $row=['id'=>0,'name'=>'','profile_type'=>0,'status'=>1,'orderby'=>0];
  if($id>0){
    $r=mysqli_query($con,"SELECT * FROM `$TABLE` WHERE id=$id LIMIT 1");
    if($r && mysqli_num_rows($r)>0){ $row=mysqli_fetch_assoc($r); }
  }
  $csrf=csrf_token();
?>
  <!-- FORM CARD: Delete + Cancel removed -->
  <div class="card" style="max-width:1000px;margin-top:18px;padding:0;border-radius:12px;overflow:visible">
    <div style="padding:22px 28px;border-bottom:1px solid rgba(255,255,255,0.02);display:flex;align-items:center;justify-content:space-between">
      <div>
        <h3 style="margin:0 0 4px 0">Edit Feature</h3>
        <div style="color:#9aa3b2;font-size:0.95rem">Modify feature details below</div>
      </div>
      <div>
        <a class="btn secondary" href="<?=keep_params(['mode'=>'list','id'=>null])?>" style="padding:10px 14px">Back to List</a>
      </div>
    </div>

    <form method="post" action="<?=keep_params()?>" style="padding:20px 28px">
      <input type="hidden" name="csrf" value="<?=$csrf?>">
      <input type="hidden" name="id" value="<?=$row['id']?>">

      <!-- Inline fields row: Title | Profile Type | Status | Order -->
      <div style="display:flex;gap:18px;align-items:flex-end;flex-wrap:wrap">
        <label style="flex:1;min-width:260px">
          <div style="color:#cbd5dd;margin-bottom:6px;font-weight:600">Title *</div>
          <input class="inp" type="text" name="name" value="<?=htmlspecialchars($row['name'])?>" required style="width:100%">
        </label>

        <label style="min-width:260px">
          <div style="color:#cbd5dd;margin-bottom:6px;font-weight:600">Profile Type *</div>
          <select class="inp" name="profile_type" required style="width:100%">
            <option value="">-- Select --</option>
            <?php foreach(profile_types() as $k=>$v): ?>
              <option value="<?=$k?>" <?=((int)$row['profile_type']===$k?'selected':'')?>><?=$v?></option>
            <?php endforeach; ?>
          </select>
        </label>

        <label style="width:180px">
          <div style="color:#cbd5dd;margin-bottom:6px;font-weight:600">Status</div>
          <select class="inp" name="status" style="width:100%">
            <option value="1" <?=((int)$row['status']===1?'selected':'')?>>Active</option>
            <option value="0" <?=((int)$row['status']===0?'selected':'')?>>Inactive</option>
          </select>
        </label>

        <label style="width:120px">
          <div style="color:#cbd5dd;margin-bottom:6px;font-weight:600">Order</div>
          <input class="inp" type="number" name="orderby" value="<?= (int)$row['orderby'] ?>" style="width:100%">
        </label>
      </div>

      <!-- toolbar: only Save -->
      <div class="toolbar" style="margin-top:20px;display:flex;align-items:center;gap:12px">
        <button class="btn success" type="submit" name="save">Save</button>
      </div>
    </form>
  </div>

<?php else:
  // build WHERE
  $where=" WHERE 1=1 ";
  if($search!==''){
    $s=mysqli_real_escape_string($con,strtolower($search));
    $where.=" AND (LOWER(name) LIKE '%$s%')";
  }
  if($f_prof>0){ $where.=" AND profile_type=".intval($f_prof); }
  if($f_stat!==''){ $where.=" AND status=".intval($f_stat); }
  if($f_order!==''){ $where.=" AND orderby=".$f_order; }

  $limit = ($view==='all') ? "" : " LIMIT 50";
  $sql="SELECT * FROM `$TABLE` $where ORDER BY $order_by $limit";
  $res=mysqli_query($con,$sql);
  $rows=[]; if($res){ while($r=mysqli_fetch_assoc($res)) $rows[]=$r; }
  $csrf=csrf_token();
?>
  <!-- SEARCH / FILTER BAR (sticky) -->
  <div class="card" style="padding:0;margin-top:14px">
    <form method="get" action="" class="toolbar toolbar-inline" style="display:flex;gap:8px;align-items:center;flex-wrap:wrap;padding:16px;position:sticky;top:68px;z-index:5;background:linear-gradient(#07101a,#07101a)">
      <input type="hidden" name="mode" value="list">
      <input class="inp" type="text" name="search" placeholder="Search by feature name..." value="<?=htmlspecialchars($search)?>" style="min-width:220px">
      <select class="inp" name="profile_type" style="min-width:170px">
        <option value="0">All Profile Types</option>
        <?php foreach(profile_types() as $k=>$v): ?>
          <option value="<?=$k?>" <?=$f_prof===$k?'selected':''?>><?=$v?></option>
        <?php endforeach; ?>
      </select>
      <select class="inp" name="status" style="min-width:140px">
        <option value="">All Status</option>
        <option value="1" <?=$f_stat===""?'' : ($f_stat==1?'selected':'')?>>Active</option>
        <option value="0" <?=$f_stat===""?'' : ($f_stat==0?'selected':'')?>>Inactive</option>
      </select>
      <input class="inp" style="max-width:140px" type="number" name="orderby_eq" placeholder="Order Level" value="<?=htmlspecialchars($f_order)?>">
      <select class="inp" name="sort" style="min-width:170px">
        <option value="order_asc"  <?=$sort==='order_asc'?'selected':''?>>Order Level ↑</option>
        <option value="order_desc" <?=$sort==='order_desc'?'selected':''?>>Order Level ↓</option>
        <option value="name_asc"   <?=$sort==='name_asc'?'selected':''?>>Name A–Z</option>
        <option value="name_desc"  <?=$sort==='name_desc'?'selected':''?>>Name Z–A</option>
        <option value="id_desc"    <?=$sort==='id_desc'?'selected':''?>>Newest first</option>
        <option value="id_asc"     <?=$sort==='id_asc'?'selected':''?>>Oldest first</option>
      </select>

      <div style="margin-left:auto;display:flex;gap:8px">
        <button class="btn primary" type="submit">Search</button>
        <a class="btn secondary" href="<?=keep_params(['search'=>null,'profile_type'=>null,'status'=>null,'orderby_eq'=>null,'sort'=>null])?>">Reset</a>
      </div>
    </form>

    <!-- TABLE (scrollable) -->
    <div class="table" style="max-height:520px;overflow:auto;border-top:1px solid rgba(255,255,255,0.03)">
      <div class="t-head sticky" style="display:grid;grid-template-columns:60px 1fr 160px 120px 160px;gap:12px;align-items:center;padding:14px 18px;border-bottom:1px solid rgba(255,255,255,0.03)">
        <div>SR No</div>
        <div>Name</div>
        <div>Profile Type</div>
        <div>Order Level</div>
        <div>Status</div>
        <div style="text-align:right">Actions</div>
      </div>

      <?php if(empty($rows)): ?>
        <div class="t-row" style="padding:22px 18px;color:#9aa3b2">
          No records found.
        </div>
      <?php else: $sr=1; foreach($rows as $r): ?>
        <div class="t-row" style="display:grid;grid-template-columns:60px 1fr 160px 120px 120px 160px;gap:12px;align-items:center;padding:14px 18px;border-bottom:1px solid rgba(255,255,255,0.02)">
          <div style="color:#cbd5dd"><?=$sr++?></div>
          <div><?=htmlspecialchars($r['name'])?></div>
          <div><?=htmlspecialchars(profile_types()[(int)$r['profile_type']] ?? ('#'.$r['profile_type']))?></div>
          <div style="text-align:center"><?= (int)$r['orderby'] ?></div>
          <div>
            <?= ((int)$r['status']===1) ? '<span class="badge success">Active</span>' : '<span class="badge">Inactive</span>' ?>
          </div>
          <div style="text-align:right">
            <a class="btn secondary" href="<?=keep_params(['mode'=>'form','id'=>$r['id']])?>" style="margin-right:8px">Edit</a>
            <form method="post" action="<?=keep_params()?>" style="display:inline" onsubmit="return confirm('Delete this feature?')">
              <input type="hidden" name="csrf" value="<?=$csrf?>">
              <input type="hidden" name="id" value="<?=$r['id']?>">
              <button class="btn danger" type="submit" name="delete">Delete</button>
            </form>
          </div>
        </div>
      <?php endforeach; endif; ?>
    </div>
  </div>

<?php endif; ?>
</div>

<link rel="stylesheet" href="/adminconsole/assets/ui.css">
<?php echo ob_get_clean();
