<?php
if (session_status() === PHP_SESSION_NONE) session_start();
if (!isset($_SESSION['admin_id'])) { header("Location: login.php"); exit; }
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>Admin Console</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
    body { margin:0; font-family:Arial, sans-serif; background:#111827; color:#fff; }
    .wrapper { display:flex; height:100vh; overflow:hidden; }
    .sidebar { background:#1f2937; width:220px; transition:all .3s; padding-top:10px; position:relative; }
    .sidebar.collapsed { width:60px; }
    .sidebar .logo { text-align:center; margin-bottom:20px; }
    .sidebar .logo img { max-width:80%; height:auto; transition:.3s; }
    .sidebar.collapsed .logo img { max-width:40px; }
    .sidebar ul { list-style:none; padding:0; margin:0; }
    .sidebar ul li { padding:12px; cursor:pointer; display:flex; align-items:center; }
    .sidebar ul li:hover { background:#374151; }
    .sidebar ul li i { margin-right:10px; }
    .sidebar.collapsed ul li span { display:none; }
    .content { flex:1; padding:20px; overflow-y:auto; transition:margin-left .3s; }
    .toggle-btn { position:absolute; top:10px; right:-15px; background:#1f2937; color:#fff; border-radius:50%; width:30px; height:30px; display:flex; align-items:center; justify-content:center; cursor:pointer; }
    header { display:flex; justify-content:flex-end; align-items:center; padding:10px; background:#111827; border-bottom:1px solid #374151; position:sticky; top:0; z-index:100; }
    .logout-btn { background:#ef4444; border:none; padding:6px 12px; color:#fff; border-radius:4px; cursor:pointer; }
    /* Responsive: collapsed by default on mobile */
    @media (max-width: 767px) {
      .sidebar { width:60px; }
      .sidebar ul li span { display:none; }
      .sidebar .logo img { max-width:40px; }
    }
  </style>
</head>
<body>
<div class="wrapper">
  <div class="sidebar" id="sidebar">
    <div class="logo">
      <img src="/adminconsole/logo.png" alt="Logo">
    </div>
    <div class="toggle-btn" onclick="toggleSidebar()">☰</div>
    <ul>
      <li><i class="fa fa-home"></i><span>Dashboard</span></li>
      <li><i class="fa fa-cogs"></i><span>Masters</span></li>
      <li><i class="fa fa-users"></i><span>Users</span></li>
    </ul>
  </div>
  <div class="content" id="content">
    <header>
      <span></span>
      <button class="logout-btn" onclick="location.href='logout.php'">Logout</button>
    </header>
    <main>
      <?php include "index_content.php"; ?>
    </main>
  </div>
</div>
<script>
function toggleSidebar(){
  document.getElementById("sidebar").classList.toggle("collapsed");
}
</script>
</body>
</html>
